

/*<-------------------- steup --------------------------*/

var years = [2011, 2013, 2014, 2015, 2017, 2018, 2019];

var csvdata = d3.select("#csvdata").text();
csvdata = d3.csv.parse(csvdata);

var week = d3.time.format("%U"),
  month = d3.time.format("%m"),
  year = d3.time.format("%Y"),
  day = d3.time.format("%j"),
  dayofWeek = d3.time.format("%w"),
  format = d3.time.format("%Y-%m-%d"),
  calFormat = d3.time.format("%b-%d");

var svgWidth = 1280,
  svgHeight = 7000;

var colorRange = [
"#68D888",
"#CF6C2A",
"#CCDA40",
"#5B8866",
"#A27F49",
"#71D944",
"#C7D585",
"#7DD7BD",
"#5E8F34",
"#D3A839"];


var cellSize = 18,
  m = [40, (2* (svgWidth - cellSize * 53) / 3), 40, ((svgWidth - cellSize * 53) / 3)];

var width = cellSize * 53

d3.select("body").append("div")
  .attr("id", "top")
  .style({"width": svgWidth, "margin": "auto", "height": "40px", "text-align":"left", "padding": "20px"});
  
d3.select("#top")
  .append("button")
    .attr({"class": "download", "type": "Button", "href": "#"})
    .on("click", crowbar)
    .text("Download SVG");


d3.select("#top")
  .append("span").style({"padding": "0px 0px 0px 15px"})
  .html("Analysis Year: ")
  .append("select").attr("id", "refYear").attr("onchange", "calendarRegen()")
  .selectAll("option")
  .data(years)
  .enter().append("option").html(function(d) { return d; });

document.getElementById("refYear").options[1].defaultSelected = true;





d3.select("body").append("div")
  .attr("id", "container")
  .style({"width": svgWidth, "margin": "auto"});

d3.select("body").append("div")
  .attr("id", "#bottom")
  .style({"width": svgWidth, "margin": "auto"});

//format the data
var analysisYears = document.getElementById("refYear");
var refYear = +analysisYears.options[analysisYears.selectedIndex].text;

var days = d3.time.days(new Date(refYear, 0, 1), new Date(refYear + 1, 0, 1)),
  months = d3.time.months(new Date(refYear, 0, 1), new Date(refYear+1, 0, 1));

var variables = d3.keys(csvdata[0]);


var colorInput = d3.select("body").selectAll(".colorInput")
  .data(variables)
  .enter().append("div")
  .style("position", "absolute")
  .style("left", "50px")
  .style("top", function(d, i){ return (i * (cellSize * 7 + m[0] + 60) + (6* m[0])) + "px";}); 


colorInput.html("Display Color: ")
  .append("select").attr("id", function(d){ return "color_" + d;})
  .style("display", "block")
  .attr("onchange", "colorShift()")
  .selectAll("option")
  .data(colorRange)
  .enter().append("option").html(function(p){ return p; });

var svg = d3.select("#container").append("svg")
  .attr("id", "visualization")
  .attr("width", svgWidth)
  .attr("height", svgHeight)
  .attr("xmlns", "http://www.w3.org/2000/svg");















/* -------------------- Brush and redraw functions --------------------- */

var hourRange = [
"12 AM",
"1 AM",
"2 AM",
"3 AM",
"4 AM",
"5 AM",
"6 AM",
"7 AM",
"8 AM",
"9 AM",
"10 AM",
"11 AM",
"Noon",
"1 PM",
"2 PM",
"3 PM",
"4 PM",
"5 PM",
"6 PM",
"7 PM",
"8 PM",
"9 PM",
"10 PM",
"11 PM",
"12 AM"];

var brushHeight = 10

var x = d3.scale.linear()
  .domain(d3.extent(d3.range(25)))
  .range([0, width]);

var timeBrush = d3.svg.brush()
  .x(x)
  .extent(d3.extent(d3.range(25)))
  .on("brush", brushed)
  .on("brushend", brushend);

var brushContainer = d3.select("#visualization").append("g")
  .attr("id", "brushContainer")
  .attr("transform", "translate(" + m[1] + "," + m[0] + ")");


brushContainer.append("rect")
  .attr("class", "grid-background")
  .attr("width", width)
  .attr("height", brushHeight);


brushContainer.append("g")
  .attr("class", "grid")
  .attr("transform", "translate(0," + brushHeight + ")")
  .call(d3.svg.axis()
    .scale(x)
    .orient("bottom")
    .tickValues(d3.range(25))
    .tickSize(-brushHeight)
    .tickFormat(""));


brushContainer.append("g")
  .attr("class", "axis")
  //.attr("transform", "translate(0," + brushHeight +")")
  .call(d3.svg.axis()
    .scale(x)
    .orient("top")
    .tickValues(d3.range(25)))
  .selectAll("text")
    .data(hourRange)
    .attr("y", -12)
    .attr("x", 5)
    .attr("transform", "rotate(-30)")
    .style("text-anchor", "start")
    .text(function(d) { return d; });



var gBrush = brushContainer.append("g")
  .attr("class", "brush")
  .attr("transform", "translate(0," + (-brushHeight/2) + ")")
  .call(timeBrush);

gBrush.selectAll("rect")
  .attr("height", brushHeight * 2);


function brushed() {
  var extent0 = timeBrush.extent(),
    extent1;

    if(d3.event.mode === "move") {
      var d0 = Math.round(extent0[0]),
        d1 = d0 + Math.round(extent0[1] - extent0[0]);
      extent1 = [d0, d1];
    }

    else {
      extent1 = extent0.map(Math.round);

      if(extent1[0] >= extent1[1]) {
        extent1[0] = Math.floor(extent0[0]);
        extent1[1] = Math.ceil(extent0[1]);
      }
    }
  d3.select(this).call(timeBrush.extent(extent1));
}

var timeRange = timeBrush.extent();

function brushend() {
  timeRange = timeBrush.extent();
  calendarRegen(timeRange);

}



/*
function calData(input) {

  var dailyTotals = days.map(function(d, i) { 
    var dayTotal = d3.sum(csvdata.slice((i*24), (i*24 + 24)), function(p) { return +p[input]; });
    return {"id": d, "value": dayTotal, "varLabel": input};
  });
  return dailyTotals;
}
*/


 




















/* ---------------- data ------------------ */


function calData(input, theRange) {

  var dailyTotals = days.map(function(d, i) { 
    var dayTotal = d3.sum(csvdata.slice((i*24 + theRange[0]), (i*24 + theRange[1])), function(p) { return +p[input]; });
    return {"id": d, "value": dayTotal, "varLabel": input};
  });
  return dailyTotals;
}


var color = {};

variables.forEach(function(d) {
  
  var colorSelect = document.getElementById("color_" + d),
  calColor = colorSelect.options[colorSelect.selectedIndex].text;



  color[d] = d3.scale.linear()
  .range(["#fff", calColor])
  .domain(d3.extent(calData(d, timeRange), function(p) { return p.value; }));

  /*
  .domain([d3.min(variables, function(p) { return d3.min(calData(p), function(pp) { return pp.value;} );} ), 
    d3.max(variables, function(p) { return d3.max(calData(p), function(pp) { return pp.value;} );} )]);
  
  use this if you want domains for each zone and comment the above
  .domain(d3.extent(calData(d), function(p) { return p.value; }));
  */

});














/* ------------- Calendar -------------------- */

var offset = function(d, i) {
  return (i * (cellSize * 7 + m[0]) + m[0]);
}


// This is the custom month path (no border)
function monthPath(t0) {
  if (refYear == 2011) {
  
    if (t0 === months[3] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[4]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2013) {

    if (t0 === months[7] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[8] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

 else if (refYear == 2014) {

    if (t0 === months[4]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[5]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2015) {

    if (t0 === months[0] || t0 === months[9]){
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[1]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[2] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }


  else if (refYear == 2017) {

    if (t0 === months[0] || t0 === months[9]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
    else if (t0 === months[8]){
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2018) {

    if (t0 === months[2] || t0 === months[5]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[3] || t0 === months[6]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }

  else if (refYear == 2019) {

    if (t0 === months[7] || t0 === months[10]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + (w1 + 1) * cellSize + "," + 7 * cellSize
        + "V" + 0;
    }
    else if (t0 === months[8] || t0 === months[11]) {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + w0 * cellSize + "," + 0
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0;
    }
    else {
      var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
        d0 = +dayofWeek(t0), w0 = +week(t0),
        d1 = +dayofWeek(t1), w1 = +week(t1);
    return "M" + (w0 + 1) * cellSize + "," + 0
        + "V" + d0 * cellSize + "H" + w0 * cellSize
        + "V" + 7 * cellSize
        + "M" + w1 * cellSize + "," + 7 * cellSize
        + "V" + (d1 + 1) * cellSize + "H" + (w1 + 1) * cellSize + "V" + 0; 
    }
  }
}
/* this is the original version
function monthPath(t0) {
  var t1 = new Date(t0.getFullYear(), t0.getMonth() + 1, 0),
      d0 = +dayofWeek(t0), w0 = +week(t0),
      d1 = +dayofWeek(t1), w1 = +week(t1);
  return "M" + (w0 + 1) * cellSize + "," + d0 * cellSize
      + "H" + w0 * cellSize + "V" + 7 * cellSize
      + "H" + w1 * cellSize + "V" + (d1 + 1) * cellSize
      + "H" + (w1 + 1) * cellSize + "V" + 0
      + "H" + (w0 + 1) * cellSize + "Z"; 
}
*/



var calendar = d3.select("#visualization").selectAll(".calendar")
  .data(variables)
.enter().append("g")
  .attr("class", "calendar")
  .attr("transform", function(d, i) { return "translate(" + m[1] + "," + (i * (cellSize * 7 + m[0] + 60) + (3*m[0])) + ")"; });

var rect = calendar.selectAll(".day")
  .data(function(d) { return calData(d, timeRange); })
.enter().append("rect")
  .attr({"class": "day", "width": cellSize, "height": cellSize})
  .attr("x", function(dd) { return week(dd.id) * cellSize; })
  .attr("y", function(dd) { return dayofWeek(dd.id) * cellSize; })
  .style("fill", function(dd) { return color[dd.varLabel](dd.value); });


rect.append("title")
  .text(function(dd) { return format(dd.id) + ": " + dd.value + " Hours"; });


calendar.selectAll(".month")
  .data(months)
.enter().append("path")
  .attr("class", "month")
  .attr("d", monthPath);

calendar.append("g").attr("class", "monthLabels")
  .attr("transform", "translate(0,-20)")
  .selectAll("text")
  .data(months)
  .enter().append("text")
  .attr("y", 0)
  .attr("x", function(p, i) { return (i * (width/12) + (width/24)) ;})
  .attr("dy", ".71em")
  .style("text-anchor", "middle")
  .text(function(p) { return d3.time.format("%B")(p); });

calendar.append("g").attr("class", "dayLabels")
  .attr("transform", "translate(-15, -3)")
  .selectAll("text")
  .data(["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"])
  .enter().append("text")
  .attr("y", function(p, i) { return (i * cellSize + cellSize/2); })
  .attr("dy", ".71em")
  .style("text-anchor", "end")
  .text(function(p) { return p; });


calendar.append("g").attr("class", "varLabel")
  .attr("transform", "translate(0," + (cellSize * 7 + 20) + ")")
  .append("text")
  .style("text-anchor", "start")
  .text(function(d) { return d; });






















/* -------------------- Legend --------------------- */

var lRange = 6;

var legend = calendar.append("g")
  .attr("class", "legend")
  .attr("transform", "translate(" + (width - cellSize * 8) + "," + (cellSize * 7 + 10) + ")");

legend.selectAll("rect")
  .data(function(d){ return d3.range(lRange).map(function(p){ return d;}); })
  .enter().append("rect")
  .attr({"class": "day", "width": (cellSize/1.5), "height": (cellSize/1.5)})
  .attr("transform", function(dd, i) { return "translate(" + (i * cellSize/1.1 + 10) + ",0)"; })
  .style("fill", function(dd, i) { return color[dd](i * color[dd].domain()[1]/lRange)})

legend.selectAll("text")
  .data(function(d) { return color[d].domain(); })
.enter().append("text")
  .style("text-anchor", "start")
  .attr("x", function(p, i){ return (i * cellSize * lRange) ; })
  .attr("y", cellSize/1.75)
  .text(function(p){ return p;});

























/* -------------------- Transitions --------------------- */


function calendarRegen(theRange) {

  variables.forEach(function(d) {
    color[d].domain(d3.extent(calData(d, timeRange), function(p) { return p.value; }));

  });

  refYear = +analysisYears.options[analysisYears.selectedIndex].text;
  
  days = d3.time.days(new Date(refYear, 0, 1), new Date(refYear + 1, 0, 1)),
  months = d3.time.months(new Date(refYear, 0, 1), new Date(refYear+1, 0, 1));

  calendar.selectAll(".day")
    .data(function(d) { return calData(d, theRange); })
  .transition().duration(0)
    .attr("x", function(dd) { return week(dd.id) * cellSize; })
    .attr("y", function(dd) { return dayofWeek(dd.id) * cellSize; })
    .style("fill", function(dd) { return color[dd.varLabel](dd.value); })
    .select("title")
    .text(function(dd) { return format(dd.id) + ": " + dd.value + " Hours"; });
    //.datum(format);

  calendar.selectAll(".month")
  .data(months)
  .transition().duration(0)
  .attr("d", monthPath);


  legend.selectAll("text")
    .data(function(d) { return [0, (theRange[1] - theRange[0])]; })
  .transition().duration(0)
    .text(function(p){ return p;});
}


function colorShift() {

  variables.forEach(function(d) {
  
    var colorSelect = document.getElementById("color_" + d),
    calColor = colorSelect.options[colorSelect.selectedIndex].text;

    color[d].range(["#fff", calColor]);

  });

  calendarRegen(timeRange);

  legend.selectAll("rect")
    .style("fill", function(dd, i) { return color[dd](i * color[dd].domain()[1]/lRange)});

}


























/* SVG Crowbar -------------------------------------------------*/




function crowbar() {
  var doctype = '<?xml version="1.0" standalone="no"?><!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN" "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">';

  window.URL = (window.URL || window.webkitURL);

  var script = document.createElement('script');
  script.onload = initialize;
  script.src = "http://d3js.org/d3.v3.min.js";
  document.head.appendChild(script);

  function initialize() {
    var documents = [window.document],
        SVGSources = [];
    d3.selectAll("iframe").each(function() {
      if (this.contentDocument) {
        documents.push(this.contentDocument);
      }
    });
    documents.forEach(function(doc) {
      var styles = getStyles(doc);
      var newSources = getSources(doc, styles);
      // because of prototype on NYT pages
      for (var i = 0; i < newSources.length; i++) {
        SVGSources.push(newSources[i]);
      };
    })
    if (SVGSources.length > 1) {
      createPopover(SVGSources);
    } else if (SVGSources.length > 0) {
      download(SVGSources[0]);
    } else {
      alert("The Crowbar couldnâ€™t find any SVG nodes.");
    }
  }

  function createPopover(sources) {
    cleanup();

  var drag = d3.behavior.drag()
      .origin(function() {
        var el = d3.select(this)
        return {
          x: el.style("left").replace("px", ""),
          y: el.style("top").replace("px", "")
        }
      })
      .on("drag", dragmove);

    sources.forEach(function(s1) {
      sources.forEach(function(s2) {
        if (s1 !== s2) {
          if ((Math.abs(s1.top - s2.top) < 38) && (Math.abs(s1.left - s2.left) < 38)) {
            s2.top += 38;
            s2.left += 38;
          }
        }
      })
    })

    var body = d3.select("body");

    var buttons = body.append("div")
        .attr("class", "svg-crowbar")
        .style("z-index", 1e7)
        .style("position", "absolute")
        .style("top", 0)
        .style("left", 0);

    var button = buttons.selectAll(".crowbar-button")
        .data(sources)
      .enter().append("div")
        .attr("class", "crowbar-button")
        .style("position", "absolute")
        .style("top", function(d) { return (d.top + document.body.scrollTop) + "px"; })
        .style("left", function(d) { return (document.body.scrollLeft + d.left) + "px"; })
        .style("padding", "4px")
        .style("border-radius", "3px")
        .style("color", "white")
        .style("text-align", "center")
        .style("font-family", "'Helvetica Neue'")
        .style("background", "rgba(0, 0, 0, 0.8)")
        .style("box-shadow", "0px 4px 18px rgba(0, 0, 0, 0.4)")
        .style("cursor", "move")
        .text(function(d, i) { return "SVG #" + i + ": " + (d.id ? "#" + d.id : "") + (d.class ? "." + d.class : "")})
      .append("button")
        .style("width", "150px")
        .style("font-size", "12px")
        .style("line-height", "1.4em")
        .style("margin", "5px 0 0 0")
        .text("Download")
        .on("click", function(d, i) {
          d3.event.preventDefault();
          download(d);
        });

    buttons.selectAll(".crowbar-button").call(drag);

    var html = body.append("div")
        .attr("class", "svg-crowbar")
        .style("background", "rgba(255, 255, 255, 0.7)")
        .style("position", "fixed")
        .style("left", 0)
        .style("top", 0)
        .style("width", "100%")
        .style("height", "100%");

    function dragmove(d) {
      d3.select(this)
          .style("left", d3.event.x + "px")
          .style("top", d3.event.y + "px");
    }
  }

  function cleanup() {
    d3.selectAll(".svg-crowbar").remove();
  }



  function getSources(doc, styles) {
    var svgInfo = [],
        svgs = d3.select(doc).selectAll("svg");

    styles = (styles === undefined) ? "" : styles;

    svgs.each(function () {
      var svg = d3.select(this);
      svg.attr("version", "1.1")
        .insert("defs", ":first-child")
          .attr("class", "svg-crowbar")
        .append("style")
          .attr("type", "text/css");

      // removing attributes so they aren't doubled up
      svg.node().removeAttribute("xmlns");
      svg.node().removeAttribute("xlink");

      // These are needed for the svg
      if (!svg.node().hasAttributeNS(d3.ns.prefix.xmlns, "xmlns")) {
        svg.node().setAttributeNS(d3.ns.prefix.xmlns, "xmlns", d3.ns.prefix.svg);
      }

      if (!svg.node().hasAttributeNS(d3.ns.prefix.xmlns, "xmlns:xlink")) {
        svg.node().setAttributeNS(d3.ns.prefix.xmlns, "xmlns:xlink", d3.ns.prefix.xlink);
      }

      var source = (new XMLSerializer()).serializeToString(svg.node()).replace('</style>', '<![CDATA[' + styles + ']]></style>');
      var rect = svg.node().getBoundingClientRect();
      svgInfo.push({
        top: rect.top,
        left: rect.left,
        width: rect.width,
        height: rect.height,
        class: svg.attr("class"),
        id: svg.attr("id"),
        childElementCount: svg.node().childElementCount,
        source: [doctype + source]
      });
    });
    return svgInfo;
  }

  function download(source) {
    var filename = "untitled";

    if (source.id) {
      filename = source.id;
    } else if (source.class) {
      filename = source.class;
    } else if (window.document.title) {
      filename = window.document.title.replace(/[^a-z0-9]/gi, '-').toLowerCase();
    }

    var url = window.URL.createObjectURL(new Blob(source.source, { "type" : "text\/xml" }));

    var a = d3.select("body")
        .append('a')
        .attr("class", "svg-crowbar")
        .attr("download", filename + ".svg")
        .attr("href", url)
        .style("display", "none");

    a.node().click();

    setTimeout(function() {
      window.URL.revokeObjectURL(url);
    }, 10);
  }

  function getStyles(doc) {
    var styles = "",
        styleSheets = doc.styleSheets;

    if (styleSheets) {
      for (var i = 0; i < styleSheets.length; i++) {
        processStyleSheet(styleSheets[i]);
      }
    }

    function processStyleSheet(ss) {
      if (ss.cssRules) {
        for (var i = 0; i < ss.cssRules.length; i++) {
          var rule = ss.cssRules[i];
          if (rule.type === 3) {
            // Import Rule
            processStyleSheet(rule.styleSheet);
          } else {
            // hack for illustrator crashing on descendent selectors
            if (rule.selectorText) {
              if (rule.selectorText.indexOf(">") === -1) {
                styles += "\n" + rule.cssText;
              }
            }
          }
        }
      }
    }
    return styles;
  }

}